#!/usr/bin/env bash

set -o errexit
set -o errtrace
set -o nounset
set -o pipefail

###############################################################################
### Parametr powłoki
targetuser="${1:-mhausenblas}"


###############################################################################
### Sprawdzenie, czy zależności zostały spełnione

if ! [ -x "$(command -v jq)" ]
then
  echo "Polecenie jq jest niedostępne" >&2
  exit 1
fi

###############################################################################
### Kod główny skryptu

githubapi="https://api.github.com/users/"
tmpuserdump="/tmp/ghuserdump_$targetuser.json"
result=$(curl -s $githubapi$targetuser)
echo $result > $tmpuserdump
name=$(jq .name $tmpuserdump -r)
created_at=$(jq .created_at $tmpuserdump -r)
joinyear=$(echo $created_at | cut -f1 -d"-")
echo $name dołączył(a) do serwisu GitHub w $joinyear roku
